package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait ServerSideEncryptionType {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType
}
object ServerSideEncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType
  ): zio.aws.devopsguru.model.ServerSideEncryptionType = value match {
    case software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType.CUSTOMER_MANAGED_KEY =>
      val r = CUSTOMER_MANAGED_KEY
      r
    case software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType.AWS_OWNED_KMS_KEY =>
      val r = AWS_OWNED_KMS_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.ServerSideEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType =
      software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_MANAGED_KEY
      extends zio.aws.devopsguru.model.ServerSideEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType =
      software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType.CUSTOMER_MANAGED_KEY
  }
  case object AWS_OWNED_KMS_KEY
      extends zio.aws.devopsguru.model.ServerSideEncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType =
      software.amazon.awssdk.services.devopsguru.model.ServerSideEncryptionType.AWS_OWNED_KMS_KEY
  }
}
