package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait ResourcePermission {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.ResourcePermission
}
object ResourcePermission {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.ResourcePermission
  ): zio.aws.devopsguru.model.ResourcePermission = value match {
    case software.amazon.awssdk.services.devopsguru.model.ResourcePermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourcePermission.FULL_PERMISSION =>
      val r = FULL_PERMISSION
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourcePermission.MISSING_PERMISSION =>
      val r = MISSING_PERMISSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.ResourcePermission {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourcePermission =
      software.amazon.awssdk.services.devopsguru.model.ResourcePermission.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_PERMISSION
      extends zio.aws.devopsguru.model.ResourcePermission {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourcePermission =
      software.amazon.awssdk.services.devopsguru.model.ResourcePermission.FULL_PERMISSION
  }
  case object MISSING_PERMISSION
      extends zio.aws.devopsguru.model.ResourcePermission {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourcePermission =
      software.amazon.awssdk.services.devopsguru.model.ResourcePermission.MISSING_PERMISSION
  }
}
