package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait InsightFeedbackOption {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption
}
object InsightFeedbackOption {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption
  ): zio.aws.devopsguru.model.InsightFeedbackOption = value match {
    case software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.VALID_COLLECTION =>
      val r = VALID_COLLECTION
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.RECOMMENDATION_USEFUL =>
      val r = RECOMMENDATION_USEFUL
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.ALERT_TOO_SENSITIVE =>
      val r = ALERT_TOO_SENSITIVE
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.DATA_NOISY_ANOMALY =>
      val r = DATA_NOISY_ANOMALY
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.DATA_INCORRECT =>
      val r = DATA_INCORRECT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.InsightFeedbackOption {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption =
      software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.UNKNOWN_TO_SDK_VERSION
  }
  case object VALID_COLLECTION
      extends zio.aws.devopsguru.model.InsightFeedbackOption {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption =
      software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.VALID_COLLECTION
  }
  case object RECOMMENDATION_USEFUL
      extends zio.aws.devopsguru.model.InsightFeedbackOption {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption =
      software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.RECOMMENDATION_USEFUL
  }
  case object ALERT_TOO_SENSITIVE
      extends zio.aws.devopsguru.model.InsightFeedbackOption {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption =
      software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.ALERT_TOO_SENSITIVE
  }
  case object DATA_NOISY_ANOMALY
      extends zio.aws.devopsguru.model.InsightFeedbackOption {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption =
      software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.DATA_NOISY_ANOMALY
  }
  case object DATA_INCORRECT
      extends zio.aws.devopsguru.model.InsightFeedbackOption {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption =
      software.amazon.awssdk.services.devopsguru.model.InsightFeedbackOption.DATA_INCORRECT
  }
}
