package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait CostEstimationStatus {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus
}
object CostEstimationStatus {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus
  ): zio.aws.devopsguru.model.CostEstimationStatus = value match {
    case software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus.ONGOING =>
      val r = ONGOING
      r
    case software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.CostEstimationStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus =
      software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONGOING extends zio.aws.devopsguru.model.CostEstimationStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus =
      software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus.ONGOING
  }
  case object COMPLETED extends zio.aws.devopsguru.model.CostEstimationStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus =
      software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus.COMPLETED
  }
}
