package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{TagValue, AppBoundaryKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagCollectionFilter(
    appBoundaryKey: AppBoundaryKey,
    tagValues: Iterable[TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.TagCollectionFilter = {
    import TagCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.TagCollectionFilter
      .builder()
      .appBoundaryKey(AppBoundaryKey.unwrap(appBoundaryKey): java.lang.String)
      .tagValues(tagValues.map { item =>
        TagValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.TagCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.TagCollectionFilter.wrap(buildAwsValue())
}
object TagCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.TagCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.TagCollectionFilter =
      zio.aws.devopsguru.model.TagCollectionFilter(appBoundaryKey, tagValues)
    def appBoundaryKey: AppBoundaryKey
    def tagValues: List[TagValue]
    def getAppBoundaryKey: ZIO[Any, Nothing, AppBoundaryKey] =
      ZIO.succeed(appBoundaryKey)
    def getTagValues: ZIO[Any, Nothing, List[TagValue]] = ZIO.succeed(tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.TagCollectionFilter
  ) extends zio.aws.devopsguru.model.TagCollectionFilter.ReadOnly {
    override val appBoundaryKey: AppBoundaryKey =
      zio.aws.devopsguru.model.primitives.AppBoundaryKey(impl.appBoundaryKey())
    override val tagValues: List[TagValue] = impl
      .tagValues()
      .asScala
      .map { item =>
        zio.aws.devopsguru.model.primitives.TagValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.TagCollectionFilter
  ): zio.aws.devopsguru.model.TagCollectionFilter.ReadOnly = new Wrapper(impl)
}
