package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{AnalyzedResourceCount, StackName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudFormationHealth(
    stackName: Optional[StackName] = Optional.Absent,
    insight: Optional[zio.aws.devopsguru.model.InsightHealth] = Optional.Absent,
    analyzedResourceCount: Optional[AnalyzedResourceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth = {
    import CloudFormationHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .optionallyWith(
        analyzedResourceCount.map(value =>
          AnalyzedResourceCount.unwrap(value): java.lang.Long
        )
      )(_.analyzedResourceCount)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly =
    zio.aws.devopsguru.model.CloudFormationHealth.wrap(buildAwsValue())
}
object CloudFormationHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudFormationHealth =
      zio.aws.devopsguru.model.CloudFormationHealth(
        stackName.map(value => value),
        insight.map(value => value.asEditable),
        analyzedResourceCount.map(value => value)
      )
    def stackName: Optional[StackName]
    def insight: Optional[zio.aws.devopsguru.model.InsightHealth.ReadOnly]
    def analyzedResourceCount: Optional[AnalyzedResourceCount]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getInsight
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightHealth.ReadOnly] =
      AwsError.unwrapOptionField("insight", insight)
    def getAnalyzedResourceCount: ZIO[Any, AwsError, AnalyzedResourceCount] =
      AwsError.unwrapOptionField("analyzedResourceCount", analyzedResourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
  ) extends zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly {
    override val stackName: Optional[StackName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.devopsguru.model.primitives.StackName(value))
    override val insight
        : Optional[zio.aws.devopsguru.model.InsightHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insight())
        .map(value => zio.aws.devopsguru.model.InsightHealth.wrap(value))
    override val analyzedResourceCount: Optional[AnalyzedResourceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzedResourceCount())
        .map(value =>
          zio.aws.devopsguru.model.primitives.AnalyzedResourceCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
  ): zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly = new Wrapper(impl)
}
