package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeServiceIntegrationResponse(
    serviceIntegration: Optional[
      zio.aws.devopsguru.model.ServiceIntegrationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse = {
    import DescribeServiceIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse
      .builder()
      .optionallyWith(serviceIntegration.map(value => value.buildAwsValue()))(
        _.serviceIntegration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeServiceIntegrationResponse
      .wrap(buildAwsValue())
}
object DescribeServiceIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeServiceIntegrationResponse =
      zio.aws.devopsguru.model.DescribeServiceIntegrationResponse(
        serviceIntegration.map(value => value.asEditable)
      )
    def serviceIntegration
        : Optional[zio.aws.devopsguru.model.ServiceIntegrationConfig.ReadOnly]
    def getServiceIntegration: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceIntegrationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("serviceIntegration", serviceIntegration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse
  ) extends zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly {
    override val serviceIntegration
        : Optional[zio.aws.devopsguru.model.ServiceIntegrationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceIntegration())
        .map(value =>
          zio.aws.devopsguru.model.ServiceIntegrationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse
  ): zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly =
    new Wrapper(impl)
}
