package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class DescribeAccountOverviewRequest(
    fromTime: Timestamp,
    toTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest = {
    import DescribeAccountOverviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest
      .builder()
      .fromTime(Timestamp.unwrap(fromTime): Instant)
      .optionallyWith(toTime.map(value => Timestamp.unwrap(value): Instant))(
        _.toTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeAccountOverviewRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeAccountOverviewRequest
      .wrap(buildAwsValue())
}
object DescribeAccountOverviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeAccountOverviewRequest =
      zio.aws.devopsguru.model
        .DescribeAccountOverviewRequest(fromTime, toTime.map(value => value))
    def fromTime: Timestamp
    def toTime: Optional[Timestamp]
    def getFromTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(fromTime)
    def getToTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("toTime", toTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest
  ) extends zio.aws.devopsguru.model.DescribeAccountOverviewRequest.ReadOnly {
    override val fromTime: Timestamp =
      zio.aws.devopsguru.model.primitives.Timestamp(impl.fromTime())
    override val toTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.toTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest
  ): zio.aws.devopsguru.model.DescribeAccountOverviewRequest.ReadOnly =
    new Wrapper(impl)
}
