package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.NotificationChannelId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NotificationChannel(
    id: Optional[NotificationChannelId] = Optional.Absent,
    config: Optional[zio.aws.devopsguru.model.NotificationChannelConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.NotificationChannel = {
    import NotificationChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.NotificationChannel
      .builder()
      .optionallyWith(
        id.map(value => NotificationChannelId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.NotificationChannel.ReadOnly =
    zio.aws.devopsguru.model.NotificationChannel.wrap(buildAwsValue())
}
object NotificationChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.NotificationChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.NotificationChannel =
      zio.aws.devopsguru.model.NotificationChannel(
        id.map(value => value),
        config.map(value => value.asEditable)
      )
    def id: Optional[NotificationChannelId]
    def config
        : Optional[zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly]
    def getId: ZIO[Any, AwsError, NotificationChannelId] =
      AwsError.unwrapOptionField("id", id)
    def getConfig: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly
    ] = AwsError.unwrapOptionField("config", config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannel
  ) extends zio.aws.devopsguru.model.NotificationChannel.ReadOnly {
    override val id: Optional[NotificationChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.devopsguru.model.primitives.NotificationChannelId(value)
      )
    override val config: Optional[
      zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.config())
      .map(value =>
        zio.aws.devopsguru.model.NotificationChannelConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannel
  ): zio.aws.devopsguru.model.NotificationChannel.ReadOnly = new Wrapper(impl)
}
