package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  RecommendationReason,
  RecommendationDescription,
  RecommendationCategory,
  RecommendationLink,
  RecommendationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Recommendation(
    description: Optional[RecommendationDescription] = Optional.Absent,
    link: Optional[RecommendationLink] = Optional.Absent,
    name: Optional[RecommendationName] = Optional.Absent,
    reason: Optional[RecommendationReason] = Optional.Absent,
    relatedEvents: Optional[
      Iterable[zio.aws.devopsguru.model.RecommendationRelatedEvent]
    ] = Optional.Absent,
    relatedAnomalies: Optional[
      Iterable[zio.aws.devopsguru.model.RecommendationRelatedAnomaly]
    ] = Optional.Absent,
    category: Optional[RecommendationCategory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.Recommendation
      .builder()
      .optionallyWith(
        description.map(value =>
          RecommendationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        link.map(value => RecommendationLink.unwrap(value): java.lang.String)
      )(_.link)
      .optionallyWith(
        name.map(value => RecommendationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        reason.map(value =>
          RecommendationReason.unwrap(value): java.lang.String
        )
      )(_.reason)
      .optionallyWith(
        relatedEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedEvents)
      .optionallyWith(
        relatedAnomalies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedAnomalies)
      .optionallyWith(
        category.map(value =>
          RecommendationCategory.unwrap(value): java.lang.String
        )
      )(_.category)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.Recommendation.ReadOnly =
    zio.aws.devopsguru.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.Recommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.Recommendation =
      zio.aws.devopsguru.model.Recommendation(
        description.map(value => value),
        link.map(value => value),
        name.map(value => value),
        reason.map(value => value),
        relatedEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedAnomalies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        category.map(value => value)
      )
    def description: Optional[RecommendationDescription]
    def link: Optional[RecommendationLink]
    def name: Optional[RecommendationName]
    def reason: Optional[RecommendationReason]
    def relatedEvents: Optional[
      List[zio.aws.devopsguru.model.RecommendationRelatedEvent.ReadOnly]
    ]
    def relatedAnomalies: Optional[
      List[zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly]
    ]
    def category: Optional[RecommendationCategory]
    def getDescription: ZIO[Any, AwsError, RecommendationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLink: ZIO[Any, AwsError, RecommendationLink] =
      AwsError.unwrapOptionField("link", link)
    def getName: ZIO[Any, AwsError, RecommendationName] =
      AwsError.unwrapOptionField("name", name)
    def getReason: ZIO[Any, AwsError, RecommendationReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getRelatedEvents: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedEvents", relatedEvents)
    def getRelatedAnomalies: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedAnomalies", relatedAnomalies)
    def getCategory: ZIO[Any, AwsError, RecommendationCategory] =
      AwsError.unwrapOptionField("category", category)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.Recommendation
  ) extends zio.aws.devopsguru.model.Recommendation.ReadOnly {
    override val description: Optional[RecommendationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.devopsguru.model.primitives.RecommendationDescription(value)
        )
    override val link: Optional[RecommendationLink] = zio.aws.core.internal
      .optionalFromNullable(impl.link())
      .map(value =>
        zio.aws.devopsguru.model.primitives.RecommendationLink(value)
      )
    override val name: Optional[RecommendationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.devopsguru.model.primitives.RecommendationName(value)
      )
    override val reason: Optional[RecommendationReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value =>
        zio.aws.devopsguru.model.primitives.RecommendationReason(value)
      )
    override val relatedEvents: Optional[
      List[zio.aws.devopsguru.model.RecommendationRelatedEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relatedEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedEvent.wrap(item)
        }.toList
      )
    override val relatedAnomalies: Optional[
      List[zio.aws.devopsguru.model.RecommendationRelatedAnomaly.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relatedAnomalies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedAnomaly.wrap(item)
        }.toList
      )
    override val category: Optional[RecommendationCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value =>
          zio.aws.devopsguru.model.primitives.RecommendationCategory(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.Recommendation
  ): zio.aws.devopsguru.model.Recommendation.ReadOnly = new Wrapper(impl)
}
