package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class AnomalyTimeRange(
    startTime: Timestamp,
    endTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange = {
    import AnomalyTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly =
    zio.aws.devopsguru.model.AnomalyTimeRange.wrap(buildAwsValue())
}
object AnomalyTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AnomalyTimeRange =
      zio.aws.devopsguru.model
        .AnomalyTimeRange(startTime, endTime.map(value => value))
    def startTime: Timestamp
    def endTime: Optional[Timestamp]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange
  ) extends zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.devopsguru.model.primitives.Timestamp(impl.startTime())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange
  ): zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly = new Wrapper(impl)
}
