package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.InsightId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteInsightRequest(id: InsightId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest = {
    import DeleteInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest
      .builder()
      .id(InsightId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.DeleteInsightRequest.ReadOnly =
    zio.aws.devopsguru.model.DeleteInsightRequest.wrap(buildAwsValue())
}
object DeleteInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DeleteInsightRequest =
      zio.aws.devopsguru.model.DeleteInsightRequest(id)
    def id: InsightId
    def getId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest
  ) extends zio.aws.devopsguru.model.DeleteInsightRequest.ReadOnly {
    override val id: InsightId =
      zio.aws.devopsguru.model.primitives.InsightId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest
  ): zio.aws.devopsguru.model.DeleteInsightRequest.ReadOnly = new Wrapper(impl)
}
