package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  CloudWatchMetricsPeriod,
  CloudWatchMetricsUnit,
  CloudWatchMetricsNamespace,
  CloudWatchMetricsMetricName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CloudWatchMetricsDetail(
    metricName: Optional[CloudWatchMetricsMetricName] = Optional.Absent,
    namespace: Optional[CloudWatchMetricsNamespace] = Optional.Absent,
    dimensions: Optional[
      Iterable[zio.aws.devopsguru.model.CloudWatchMetricsDimension]
    ] = Optional.Absent,
    stat: Optional[zio.aws.devopsguru.model.CloudWatchMetricsStat] =
      Optional.Absent,
    unit: Optional[CloudWatchMetricsUnit] = Optional.Absent,
    period: Optional[CloudWatchMetricsPeriod] = Optional.Absent,
    metricDataSummary: Optional[
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail = {
    import CloudWatchMetricsDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
      .builder()
      .optionallyWith(
        metricName.map(value =>
          CloudWatchMetricsMetricName.unwrap(value): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(
        namespace.map(value =>
          CloudWatchMetricsNamespace.unwrap(value): java.lang.String
        )
      )(_.namespace)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(stat.map(value => value.unwrap))(_.stat)
      .optionallyWith(
        unit.map(value => CloudWatchMetricsUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(
        period.map(value => CloudWatchMetricsPeriod.unwrap(value): Integer)
      )(_.period)
      .optionallyWith(metricDataSummary.map(value => value.buildAwsValue()))(
        _.metricDataSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly =
    zio.aws.devopsguru.model.CloudWatchMetricsDetail.wrap(buildAwsValue())
}
object CloudWatchMetricsDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudWatchMetricsDetail =
      zio.aws.devopsguru.model.CloudWatchMetricsDetail(
        metricName.map(value => value),
        namespace.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stat.map(value => value),
        unit.map(value => value),
        period.map(value => value),
        metricDataSummary.map(value => value.asEditable)
      )
    def metricName: Optional[CloudWatchMetricsMetricName]
    def namespace: Optional[CloudWatchMetricsNamespace]
    def dimensions: Optional[
      List[zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly]
    ]
    def stat: Optional[zio.aws.devopsguru.model.CloudWatchMetricsStat]
    def unit: Optional[CloudWatchMetricsUnit]
    def period: Optional[CloudWatchMetricsPeriod]
    def metricDataSummary: Optional[
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly
    ]
    def getMetricName: ZIO[Any, AwsError, CloudWatchMetricsMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, CloudWatchMetricsNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStat
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.CloudWatchMetricsStat] =
      AwsError.unwrapOptionField("stat", stat)
    def getUnit: ZIO[Any, AwsError, CloudWatchMetricsUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getPeriod: ZIO[Any, AwsError, CloudWatchMetricsPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getMetricDataSummary: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly
    ] = AwsError.unwrapOptionField("metricDataSummary", metricDataSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
  ) extends zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly {
    override val metricName: Optional[CloudWatchMetricsMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value =>
          zio.aws.devopsguru.model.primitives.CloudWatchMetricsMetricName(value)
        )
    override val namespace: Optional[CloudWatchMetricsNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value =>
          zio.aws.devopsguru.model.primitives.CloudWatchMetricsNamespace(value)
        )
    override val dimensions: Optional[
      List[zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.CloudWatchMetricsDimension.wrap(item)
        }.toList
      )
    override val stat
        : Optional[zio.aws.devopsguru.model.CloudWatchMetricsStat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stat())
        .map(value =>
          zio.aws.devopsguru.model.CloudWatchMetricsStat.wrap(value)
        )
    override val unit: Optional[CloudWatchMetricsUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value =>
        zio.aws.devopsguru.model.primitives.CloudWatchMetricsUnit(value)
      )
    override val period: Optional[CloudWatchMetricsPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value =>
          zio.aws.devopsguru.model.primitives.CloudWatchMetricsPeriod(value)
        )
    override val metricDataSummary: Optional[
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricDataSummary())
      .map(value =>
        zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
  ): zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly = new Wrapper(
    impl
  )
}
