package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  UuidNextToken,
  SearchOrganizationInsightsMaxResults,
  AwsAccountId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchOrganizationInsightsRequest(
    accountIds: Iterable[AwsAccountId],
    startTimeRange: zio.aws.devopsguru.model.StartTimeRange,
    filters: Optional[
      zio.aws.devopsguru.model.SearchOrganizationInsightsFilters
    ] = Optional.Absent,
    maxResults: Optional[SearchOrganizationInsightsMaxResults] =
      Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent,
    `type`: zio.aws.devopsguru.model.InsightType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest = {
    import SearchOrganizationInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        AwsAccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .startTimeRange(startTimeRange.buildAwsValue())
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          SearchOrganizationInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.SearchOrganizationInsightsRequest.ReadOnly =
    zio.aws.devopsguru.model.SearchOrganizationInsightsRequest
      .wrap(buildAwsValue())
}
object SearchOrganizationInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.SearchOrganizationInsightsRequest =
      zio.aws.devopsguru.model.SearchOrganizationInsightsRequest(
        accountIds,
        startTimeRange.asEditable,
        filters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        `type`
      )
    def accountIds: List[AwsAccountId]
    def startTimeRange: zio.aws.devopsguru.model.StartTimeRange.ReadOnly
    def filters: Optional[
      zio.aws.devopsguru.model.SearchOrganizationInsightsFilters.ReadOnly
    ]
    def maxResults: Optional[SearchOrganizationInsightsMaxResults]
    def nextToken: Optional[UuidNextToken]
    def `type`: zio.aws.devopsguru.model.InsightType
    def getAccountIds: ZIO[Any, Nothing, List[AwsAccountId]] =
      ZIO.succeed(accountIds)
    def getStartTimeRange
        : ZIO[Any, Nothing, zio.aws.devopsguru.model.StartTimeRange.ReadOnly] =
      ZIO.succeed(startTimeRange)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.SearchOrganizationInsightsFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, SearchOrganizationInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getType: ZIO[Any, Nothing, zio.aws.devopsguru.model.InsightType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest
  ) extends zio.aws.devopsguru.model.SearchOrganizationInsightsRequest.ReadOnly {
    override val accountIds: List[AwsAccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.devopsguru.model.primitives.AwsAccountId(item)
      }
      .toList
    override val startTimeRange
        : zio.aws.devopsguru.model.StartTimeRange.ReadOnly =
      zio.aws.devopsguru.model.StartTimeRange.wrap(impl.startTimeRange())
    override val filters: Optional[
      zio.aws.devopsguru.model.SearchOrganizationInsightsFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.devopsguru.model.SearchOrganizationInsightsFilters.wrap(value)
      )
    override val maxResults: Optional[SearchOrganizationInsightsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .SearchOrganizationInsightsMaxResults(value)
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val `type`: zio.aws.devopsguru.model.InsightType =
      zio.aws.devopsguru.model.InsightType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest
  ): zio.aws.devopsguru.model.SearchOrganizationInsightsRequest.ReadOnly =
    new Wrapper(impl)
}
