package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait ResourceTypeFilter {
  def unwrap
      : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter
}
object ResourceTypeFilter {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter
  ): zio.aws.devopsguru.model.ResourceTypeFilter = value match {
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.LOG_GROUPS =>
      val r = LOG_GROUPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object LOG_GROUPS extends zio.aws.devopsguru.model.ResourceTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter =
      software.amazon.awssdk.services.devopsguru.model.ResourceTypeFilter.LOG_GROUPS
  }
}
