package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PerformanceInsightsReferenceComparisonValues(
    referenceScalar: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar
    ] = Optional.Absent,
    referenceMetric: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceComparisonValues = {
    import PerformanceInsightsReferenceComparisonValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceComparisonValues
      .builder()
      .optionallyWith(referenceScalar.map(value => value.buildAwsValue()))(
        _.referenceScalar
      )
      .optionallyWith(referenceMetric.map(value => value.buildAwsValue()))(
        _.referenceMetric
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues
      .wrap(buildAwsValue())
}
object PerformanceInsightsReferenceComparisonValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceComparisonValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues =
      zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues(
        referenceScalar.map(value => value.asEditable),
        referenceMetric.map(value => value.asEditable)
      )
    def referenceScalar: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar.ReadOnly
    ]
    def referenceMetric: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric.ReadOnly
    ]
    def getReferenceScalar: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar.ReadOnly
    ] = AwsError.unwrapOptionField("referenceScalar", referenceScalar)
    def getReferenceMetric: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric.ReadOnly
    ] = AwsError.unwrapOptionField("referenceMetric", referenceMetric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceComparisonValues
  ) extends zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues.ReadOnly {
    override val referenceScalar: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceScalar())
      .map(value =>
        zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar.wrap(value)
      )
    override val referenceMetric: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceMetric())
      .map(value =>
        zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceComparisonValues
  ): zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues.ReadOnly =
    new Wrapper(impl)
}
