package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventSourcesConfig(
    amazonCodeGuruProfiler: Optional[
      zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.EventSourcesConfig = {
    import EventSourcesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.EventSourcesConfig
      .builder()
      .optionallyWith(
        amazonCodeGuruProfiler.map(value => value.buildAwsValue())
      )(_.amazonCodeGuruProfiler)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly =
    zio.aws.devopsguru.model.EventSourcesConfig.wrap(buildAwsValue())
}
object EventSourcesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.EventSourcesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.EventSourcesConfig =
      zio.aws.devopsguru.model.EventSourcesConfig(
        amazonCodeGuruProfiler.map(value => value.asEditable)
      )
    def amazonCodeGuruProfiler: Optional[
      zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly
    ]
    def getAmazonCodeGuruProfiler: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amazonCodeGuruProfiler",
      amazonCodeGuruProfiler
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.EventSourcesConfig
  ) extends zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly {
    override val amazonCodeGuruProfiler: Optional[
      zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonCodeGuruProfiler())
      .map(value =>
        zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.EventSourcesConfig
  ): zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly = new Wrapper(impl)
}
