package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAnomalyResponse(
    proactiveAnomaly: Optional[zio.aws.devopsguru.model.ProactiveAnomaly] =
      Optional.Absent,
    reactiveAnomaly: Optional[zio.aws.devopsguru.model.ReactiveAnomaly] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse = {
    import DescribeAnomalyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse
      .builder()
      .optionallyWith(proactiveAnomaly.map(value => value.buildAwsValue()))(
        _.proactiveAnomaly
      )
      .optionallyWith(reactiveAnomaly.map(value => value.buildAwsValue()))(
        _.reactiveAnomaly
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeAnomalyResponse.wrap(buildAwsValue())
}
object DescribeAnomalyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeAnomalyResponse =
      zio.aws.devopsguru.model.DescribeAnomalyResponse(
        proactiveAnomaly.map(value => value.asEditable),
        reactiveAnomaly.map(value => value.asEditable)
      )
    def proactiveAnomaly
        : Optional[zio.aws.devopsguru.model.ProactiveAnomaly.ReadOnly]
    def reactiveAnomaly
        : Optional[zio.aws.devopsguru.model.ReactiveAnomaly.ReadOnly]
    def getProactiveAnomaly: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ProactiveAnomaly.ReadOnly
    ] = AwsError.unwrapOptionField("proactiveAnomaly", proactiveAnomaly)
    def getReactiveAnomaly: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ReactiveAnomaly.ReadOnly
    ] = AwsError.unwrapOptionField("reactiveAnomaly", reactiveAnomaly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse
  ) extends zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly {
    override val proactiveAnomaly
        : Optional[zio.aws.devopsguru.model.ProactiveAnomaly.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proactiveAnomaly())
        .map(value => zio.aws.devopsguru.model.ProactiveAnomaly.wrap(value))
    override val reactiveAnomaly
        : Optional[zio.aws.devopsguru.model.ReactiveAnomaly.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reactiveAnomaly())
        .map(value => zio.aws.devopsguru.model.ReactiveAnomaly.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse
  ): zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly = new Wrapper(
    impl
  )
}
