package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  UuidNextToken,
  ListMonitoredResourcesMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMonitoredResourcesRequest(
    filters: zio.aws.devopsguru.model.ListMonitoredResourcesFilters,
    maxResults: Optional[ListMonitoredResourcesMaxResults] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest = {
    import ListMonitoredResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
      .builder()
      .filters(filters.buildAwsValue())
      .optionallyWith(
        maxResults.map(value =>
          ListMonitoredResourcesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListMonitoredResourcesRequest.ReadOnly =
    zio.aws.devopsguru.model.ListMonitoredResourcesRequest.wrap(buildAwsValue())
}
object ListMonitoredResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListMonitoredResourcesRequest =
      zio.aws.devopsguru.model.ListMonitoredResourcesRequest(
        filters.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly
    def maxResults: Optional[ListMonitoredResourcesMaxResults]
    def nextToken: Optional[UuidNextToken]
    def getFilters: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly
    ] = ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, ListMonitoredResourcesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
  ) extends zio.aws.devopsguru.model.ListMonitoredResourcesRequest.ReadOnly {
    override val filters
        : zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly =
      zio.aws.devopsguru.model.ListMonitoredResourcesFilters
        .wrap(impl.filters())
    override val maxResults: Optional[ListMonitoredResourcesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .ListMonitoredResourcesMaxResults(value)
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest
  ): zio.aws.devopsguru.model.ListMonitoredResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
