package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  UuidNextToken,
  ListAnomalousLogGroupsMaxResults,
  InsightId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAnomalousLogGroupsRequest(
    insightId: InsightId,
    maxResults: Optional[ListAnomalousLogGroupsMaxResults] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest = {
    import ListAnomalousLogGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListAnomalousLogGroupsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListAnomalousLogGroupsRequest.ReadOnly =
    zio.aws.devopsguru.model.ListAnomalousLogGroupsRequest.wrap(buildAwsValue())
}
object ListAnomalousLogGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListAnomalousLogGroupsRequest =
      zio.aws.devopsguru.model.ListAnomalousLogGroupsRequest(
        insightId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def insightId: InsightId
    def maxResults: Optional[ListAnomalousLogGroupsMaxResults]
    def nextToken: Optional[UuidNextToken]
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
    def getMaxResults: ZIO[Any, AwsError, ListAnomalousLogGroupsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest
  ) extends zio.aws.devopsguru.model.ListAnomalousLogGroupsRequest.ReadOnly {
    override val insightId: InsightId =
      zio.aws.devopsguru.model.primitives.InsightId(impl.insightId())
    override val maxResults: Optional[ListAnomalousLogGroupsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .ListAnomalousLogGroupsMaxResults(value)
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest
  ): zio.aws.devopsguru.model.ListAnomalousLogGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
