package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListMonitoredResourcesFilters(
    resourcePermission: zio.aws.devopsguru.model.ResourcePermission,
    resourceTypeFilters: Iterable[zio.aws.devopsguru.model.ResourceTypeFilter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesFilters = {
    import ListMonitoredResourcesFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesFilters
      .builder()
      .resourcePermission(resourcePermission.unwrap)
      .resourceTypeFiltersWithStrings(resourceTypeFilters.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly =
    zio.aws.devopsguru.model.ListMonitoredResourcesFilters.wrap(buildAwsValue())
}
object ListMonitoredResourcesFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListMonitoredResourcesFilters =
      zio.aws.devopsguru.model
        .ListMonitoredResourcesFilters(resourcePermission, resourceTypeFilters)
    def resourcePermission: zio.aws.devopsguru.model.ResourcePermission
    def resourceTypeFilters: List[zio.aws.devopsguru.model.ResourceTypeFilter]
    def getResourcePermission
        : ZIO[Any, Nothing, zio.aws.devopsguru.model.ResourcePermission] =
      ZIO.succeed(resourcePermission)
    def getResourceTypeFilters
        : ZIO[Any, Nothing, List[zio.aws.devopsguru.model.ResourceTypeFilter]] =
      ZIO.succeed(resourceTypeFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesFilters
  ) extends zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly {
    override val resourcePermission
        : zio.aws.devopsguru.model.ResourcePermission =
      zio.aws.devopsguru.model.ResourcePermission
        .wrap(impl.resourcePermission())
    override val resourceTypeFilters
        : List[zio.aws.devopsguru.model.ResourceTypeFilter] = impl
      .resourceTypeFilters()
      .asScala
      .map { item =>
        zio.aws.devopsguru.model.ResourceTypeFilter.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesFilters
  ): zio.aws.devopsguru.model.ListMonitoredResourcesFilters.ReadOnly =
    new Wrapper(impl)
}
