package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceCollectionRequest(
    resourceCollectionType: zio.aws.devopsguru.model.ResourceCollectionType,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest = {
    import GetResourceCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest
      .builder()
      .resourceCollectionType(resourceCollectionType.unwrap)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.GetResourceCollectionRequest.ReadOnly =
    zio.aws.devopsguru.model.GetResourceCollectionRequest.wrap(buildAwsValue())
}
object GetResourceCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.GetResourceCollectionRequest =
      zio.aws.devopsguru.model.GetResourceCollectionRequest(
        resourceCollectionType,
        nextToken.map(value => value)
      )
    def resourceCollectionType: zio.aws.devopsguru.model.ResourceCollectionType
    def nextToken: Optional[UuidNextToken]
    def getResourceCollectionType
        : ZIO[Any, Nothing, zio.aws.devopsguru.model.ResourceCollectionType] =
      ZIO.succeed(resourceCollectionType)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest
  ) extends zio.aws.devopsguru.model.GetResourceCollectionRequest.ReadOnly {
    override val resourceCollectionType
        : zio.aws.devopsguru.model.ResourceCollectionType =
      zio.aws.devopsguru.model.ResourceCollectionType
        .wrap(impl.resourceCollectionType())
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest
  ): zio.aws.devopsguru.model.GetResourceCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
