package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  EventName,
  EventSource,
  Timestamp,
  EventId
}
import scala.jdk.CollectionConverters._
final case class Event(
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent,
    id: Optional[EventId] = Optional.Absent,
    time: Optional[Timestamp] = Optional.Absent,
    eventSource: Optional[EventSource] = Optional.Absent,
    name: Optional[EventName] = Optional.Absent,
    dataSource: Optional[zio.aws.devopsguru.model.EventDataSource] =
      Optional.Absent,
    eventClass: Optional[zio.aws.devopsguru.model.EventClass] = Optional.Absent,
    resources: Optional[Iterable[zio.aws.devopsguru.model.EventResource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.Event
      .builder()
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(id.map(value => EventId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(time.map(value => Timestamp.unwrap(value): Instant))(
        _.time
      )
      .optionallyWith(
        eventSource.map(value => EventSource.unwrap(value): java.lang.String)
      )(_.eventSource)
      .optionallyWith(
        name.map(value => EventName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(dataSource.map(value => value.unwrap))(_.dataSource)
      .optionallyWith(eventClass.map(value => value.unwrap))(_.eventClass)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.Event.ReadOnly =
    zio.aws.devopsguru.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devopsguru.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.Event =
      zio.aws.devopsguru.model.Event(
        resourceCollection.map(value => value.asEditable),
        id.map(value => value),
        time.map(value => value),
        eventSource.map(value => value),
        name.map(value => value),
        dataSource.map(value => value),
        eventClass.map(value => value),
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def id: Optional[EventId]
    def time: Optional[Timestamp]
    def eventSource: Optional[EventSource]
    def name: Optional[EventName]
    def dataSource: Optional[zio.aws.devopsguru.model.EventDataSource]
    def eventClass: Optional[zio.aws.devopsguru.model.EventClass]
    def resources
        : Optional[List[zio.aws.devopsguru.model.EventResource.ReadOnly]]
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("id", id)
    def getTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("time", time)
    def getEventSource: ZIO[Any, AwsError, EventSource] =
      AwsError.unwrapOptionField("eventSource", eventSource)
    def getName: ZIO[Any, AwsError, EventName] =
      AwsError.unwrapOptionField("name", name)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.EventDataSource] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getEventClass: ZIO[Any, AwsError, zio.aws.devopsguru.model.EventClass] =
      AwsError.unwrapOptionField("eventClass", eventClass)
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.EventResource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.Event
  ) extends zio.aws.devopsguru.model.Event.ReadOnly {
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val id: Optional[EventId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.EventId(value))
    override val time: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.time())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val eventSource: Optional[EventSource] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSource())
      .map(value => zio.aws.devopsguru.model.primitives.EventSource(value))
    override val name: Optional[EventName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.EventName(value))
    override val dataSource
        : Optional[zio.aws.devopsguru.model.EventDataSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.devopsguru.model.EventDataSource.wrap(value))
    override val eventClass: Optional[zio.aws.devopsguru.model.EventClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventClass())
        .map(value => zio.aws.devopsguru.model.EventClass.wrap(value))
    override val resources
        : Optional[List[zio.aws.devopsguru.model.EventResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.EventResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.Event
  ): zio.aws.devopsguru.model.Event.ReadOnly = new Wrapper(impl)
}
