package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.TopicArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnsChannelConfig(
    topicArn: Optional[TopicArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.SnsChannelConfig = {
    import SnsChannelConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.SnsChannelConfig
      .builder()
      .optionallyWith(
        topicArn.map(value => TopicArn.unwrap(value): java.lang.String)
      )(_.topicArn)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly =
    zio.aws.devopsguru.model.SnsChannelConfig.wrap(buildAwsValue())
}
object SnsChannelConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.SnsChannelConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.SnsChannelConfig =
      zio.aws.devopsguru.model.SnsChannelConfig(topicArn.map(value => value))
    def topicArn: Optional[TopicArn]
    def getTopicArn: ZIO[Any, AwsError, TopicArn] =
      AwsError.unwrapOptionField("topicArn", topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.SnsChannelConfig
  ) extends zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly {
    override val topicArn: Optional[TopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.devopsguru.model.primitives.TopicArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.SnsChannelConfig
  ): zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly = new Wrapper(impl)
}
