package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventSourcesConfigResponse(
    eventSources: Optional[zio.aws.devopsguru.model.EventSourcesConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse = {
    import DescribeEventSourcesConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse
      .builder()
      .optionallyWith(eventSources.map(value => value.buildAwsValue()))(
        _.eventSources
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse
      .wrap(buildAwsValue())
}
object DescribeEventSourcesConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse =
      zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse(
        eventSources.map(value => value.asEditable)
      )
    def eventSources
        : Optional[zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly]
    def getEventSources: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly
    ] = AwsError.unwrapOptionField("eventSources", eventSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse
  ) extends zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly {
    override val eventSources
        : Optional[zio.aws.devopsguru.model.EventSourcesConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSources())
        .map(value => zio.aws.devopsguru.model.EventSourcesConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse
  ): zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly =
    new Wrapper(impl)
}
