package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CostEstimationResourceCollectionFilter(
    cloudFormation: Optional[
      zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter
    ] = Optional.Absent,
    tags: Optional[Iterable[
      zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CostEstimationResourceCollectionFilter = {
    import CostEstimationResourceCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CostEstimationResourceCollectionFilter
      .builder()
      .optionallyWith(cloudFormation.map(value => value.buildAwsValue()))(
        _.cloudFormation
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter
      .wrap(buildAwsValue())
}
object CostEstimationResourceCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CostEstimationResourceCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter =
      zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter(
        cloudFormation.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudFormation: Optional[
      zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.ReadOnly
    ]
    def tags: Optional[List[
      zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter.ReadOnly
    ]]
    def getCloudFormation: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("cloudFormation", cloudFormation)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CostEstimationResourceCollectionFilter
  ) extends zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly {
    override val cloudFormation: Optional[
      zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFormation())
      .map(value =>
        zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter
          .wrap(value)
      )
    override val tags: Optional[List[
      zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CostEstimationResourceCollectionFilter
  ): zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly =
    new Wrapper(impl)
}
