package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  InsightDescription,
  SsmOpsItemId,
  InsightName,
  InsightId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProactiveInsight(
    id: Optional[InsightId] = Optional.Absent,
    name: Optional[InsightName] = Optional.Absent,
    severity: Optional[zio.aws.devopsguru.model.InsightSeverity] =
      Optional.Absent,
    status: Optional[zio.aws.devopsguru.model.InsightStatus] = Optional.Absent,
    insightTimeRange: Optional[zio.aws.devopsguru.model.InsightTimeRange] =
      Optional.Absent,
    predictionTimeRange: Optional[
      zio.aws.devopsguru.model.PredictionTimeRange
    ] = Optional.Absent,
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent,
    ssmOpsItemId: Optional[SsmOpsItemId] = Optional.Absent,
    description: Optional[InsightDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ProactiveInsight = {
    import ProactiveInsight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
      .builder()
      .optionallyWith(
        id.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => InsightName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(insightTimeRange.map(value => value.buildAwsValue()))(
        _.insightTimeRange
      )
      .optionallyWith(predictionTimeRange.map(value => value.buildAwsValue()))(
        _.predictionTimeRange
      )
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(
        ssmOpsItemId.map(value => SsmOpsItemId.unwrap(value): java.lang.String)
      )(_.ssmOpsItemId)
      .optionallyWith(
        description.map(value =>
          InsightDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ProactiveInsight.ReadOnly =
    zio.aws.devopsguru.model.ProactiveInsight.wrap(buildAwsValue())
}
object ProactiveInsight {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ProactiveInsight =
      zio.aws.devopsguru.model.ProactiveInsight(
        id.map(value => value),
        name.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        insightTimeRange.map(value => value.asEditable),
        predictionTimeRange.map(value => value.asEditable),
        resourceCollection.map(value => value.asEditable),
        ssmOpsItemId.map(value => value),
        description.map(value => value)
      )
    def id: Optional[InsightId]
    def name: Optional[InsightName]
    def severity: Optional[zio.aws.devopsguru.model.InsightSeverity]
    def status: Optional[zio.aws.devopsguru.model.InsightStatus]
    def insightTimeRange
        : Optional[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly]
    def predictionTimeRange
        : Optional[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly]
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def ssmOpsItemId: Optional[SsmOpsItemId]
    def description: Optional[InsightDescription]
    def getId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, InsightName] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInsightTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("insightTimeRange", insightTimeRange)
    def getPredictionTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("predictionTimeRange", predictionTimeRange)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getSsmOpsItemId: ZIO[Any, AwsError, SsmOpsItemId] =
      AwsError.unwrapOptionField("ssmOpsItemId", ssmOpsItemId)
    def getDescription: ZIO[Any, AwsError, InsightDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
  ) extends zio.aws.devopsguru.model.ProactiveInsight.ReadOnly {
    override val id: Optional[InsightId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val name: Optional[InsightName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.InsightName(value))
    override val severity: Optional[zio.aws.devopsguru.model.InsightSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.devopsguru.model.InsightSeverity.wrap(value))
    override val status: Optional[zio.aws.devopsguru.model.InsightStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devopsguru.model.InsightStatus.wrap(value))
    override val insightTimeRange
        : Optional[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightTimeRange())
        .map(value => zio.aws.devopsguru.model.InsightTimeRange.wrap(value))
    override val predictionTimeRange
        : Optional[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictionTimeRange())
        .map(value => zio.aws.devopsguru.model.PredictionTimeRange.wrap(value))
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val ssmOpsItemId: Optional[SsmOpsItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssmOpsItemId())
      .map(value => zio.aws.devopsguru.model.primitives.SsmOpsItemId(value))
    override val description: Optional[InsightDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.devopsguru.model.primitives.InsightDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
  ): zio.aws.devopsguru.model.ProactiveInsight.ReadOnly = new Wrapper(impl)
}
