package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait EventClass {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.EventClass
}
object EventClass {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.EventClass
  ): zio.aws.devopsguru.model.EventClass = value match {
    case software.amazon.awssdk.services.devopsguru.model.EventClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.EventClass.INFRASTRUCTURE =>
      val r = INFRASTRUCTURE
      r
    case software.amazon.awssdk.services.devopsguru.model.EventClass.DEPLOYMENT =>
      val r = DEPLOYMENT
      r
    case software.amazon.awssdk.services.devopsguru.model.EventClass.SECURITY_CHANGE =>
      val r = SECURITY_CHANGE
      r
    case software.amazon.awssdk.services.devopsguru.model.EventClass.CONFIG_CHANGE =>
      val r = CONFIG_CHANGE
      r
    case software.amazon.awssdk.services.devopsguru.model.EventClass.SCHEMA_CHANGE =>
      val r = SCHEMA_CHANGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.devopsguru.model.EventClass {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventClass =
      software.amazon.awssdk.services.devopsguru.model.EventClass.UNKNOWN_TO_SDK_VERSION
  }
  case object INFRASTRUCTURE extends zio.aws.devopsguru.model.EventClass {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventClass =
      software.amazon.awssdk.services.devopsguru.model.EventClass.INFRASTRUCTURE
  }
  case object DEPLOYMENT extends zio.aws.devopsguru.model.EventClass {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventClass =
      software.amazon.awssdk.services.devopsguru.model.EventClass.DEPLOYMENT
  }
  case object SECURITY_CHANGE extends zio.aws.devopsguru.model.EventClass {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventClass =
      software.amazon.awssdk.services.devopsguru.model.EventClass.SECURITY_CHANGE
  }
  case object CONFIG_CHANGE extends zio.aws.devopsguru.model.EventClass {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventClass =
      software.amazon.awssdk.services.devopsguru.model.EventClass.CONFIG_CHANGE
  }
  case object SCHEMA_CHANGE extends zio.aws.devopsguru.model.EventClass {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.EventClass =
      software.amazon.awssdk.services.devopsguru.model.EventClass.SCHEMA_CHANGE
  }
}
