package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  NumProactiveInsights,
  NumReactiveInsights
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeOrganizationOverviewResponse(
    reactiveInsights: NumReactiveInsights,
    proactiveInsights: NumProactiveInsights
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse = {
    import DescribeOrganizationOverviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse
      .builder()
      .reactiveInsights(NumReactiveInsights.unwrap(reactiveInsights): Integer)
      .proactiveInsights(
        NumProactiveInsights.unwrap(proactiveInsights): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationOverviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse =
      zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse(
        reactiveInsights,
        proactiveInsights
      )
    def reactiveInsights: NumReactiveInsights
    def proactiveInsights: NumProactiveInsights
    def getReactiveInsights: ZIO[Any, Nothing, NumReactiveInsights] =
      ZIO.succeed(reactiveInsights)
    def getProactiveInsights: ZIO[Any, Nothing, NumProactiveInsights] =
      ZIO.succeed(proactiveInsights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse
  ) extends zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly {
    override val reactiveInsights: NumReactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumReactiveInsights(impl.reactiveInsights())
    override val proactiveInsights: NumProactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumProactiveInsights(impl.proactiveInsights())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse
  ): zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly =
    new Wrapper(impl)
}
