package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AmazonCodeGuruProfilerIntegration(
    status: Optional[zio.aws.devopsguru.model.EventSourceOptInStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration = {
    import AmazonCodeGuruProfilerIntegration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly =
    zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration
      .wrap(buildAwsValue())
}
object AmazonCodeGuruProfilerIntegration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration =
      zio.aws.devopsguru.model
        .AmazonCodeGuruProfilerIntegration(status.map(value => value))
    def status: Optional[zio.aws.devopsguru.model.EventSourceOptInStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.EventSourceOptInStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
  ) extends zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly {
    override val status
        : Optional[zio.aws.devopsguru.model.EventSourceOptInStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.devopsguru.model.EventSourceOptInStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AmazonCodeGuruProfilerIntegration
  ): zio.aws.devopsguru.model.AmazonCodeGuruProfilerIntegration.ReadOnly =
    new Wrapper(impl)
}
