package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait InsightStatus {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.InsightStatus
}
object InsightStatus {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.InsightStatus
  ): zio.aws.devopsguru.model.InsightStatus = value match {
    case software.amazon.awssdk.services.devopsguru.model.InsightStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightStatus.ONGOING =>
      val r = ONGOING
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightStatus.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.InsightStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightStatus =
      software.amazon.awssdk.services.devopsguru.model.InsightStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONGOING extends zio.aws.devopsguru.model.InsightStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightStatus =
      software.amazon.awssdk.services.devopsguru.model.InsightStatus.ONGOING
  }
  case object CLOSED extends zio.aws.devopsguru.model.InsightStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightStatus =
      software.amazon.awssdk.services.devopsguru.model.InsightStatus.CLOSED
  }
}
