package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait InsightType {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.InsightType
}
object InsightType {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.InsightType
  ): zio.aws.devopsguru.model.InsightType = value match {
    case software.amazon.awssdk.services.devopsguru.model.InsightType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightType.REACTIVE =>
      val r = REACTIVE
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightType.PROACTIVE =>
      val r = PROACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.devopsguru.model.InsightType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightType =
      software.amazon.awssdk.services.devopsguru.model.InsightType.UNKNOWN_TO_SDK_VERSION
  }
  case object REACTIVE extends zio.aws.devopsguru.model.InsightType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightType =
      software.amazon.awssdk.services.devopsguru.model.InsightType.REACTIVE
  }
  case object PROACTIVE extends zio.aws.devopsguru.model.InsightType {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightType =
      software.amazon.awssdk.services.devopsguru.model.InsightType.PROACTIVE
  }
}
