package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRecommendationsResponse(
    recommendations: Optional[
      Iterable[zio.aws.devopsguru.model.Recommendation]
    ] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse = {
    import ListRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse
      .builder()
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly =
    zio.aws.devopsguru.model.ListRecommendationsResponse.wrap(buildAwsValue())
}
object ListRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListRecommendationsResponse =
      zio.aws.devopsguru.model.ListRecommendationsResponse(
        recommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommendations
        : Optional[List[zio.aws.devopsguru.model.Recommendation.ReadOnly]]
    def nextToken: Optional[UuidNextToken]
    def getRecommendations: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.Recommendation.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendations", recommendations)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse
  ) extends zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly {
    override val recommendations
        : Optional[List[zio.aws.devopsguru.model.Recommendation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.Recommendation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse
  ): zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
