package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  NumOpenReactiveInsights,
  NumOpenProactiveInsights
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ServiceInsightHealth(
    openProactiveInsights: Optional[NumOpenProactiveInsights] = Optional.Absent,
    openReactiveInsights: Optional[NumOpenReactiveInsights] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ServiceInsightHealth = {
    import ServiceInsightHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ServiceInsightHealth
      .builder()
      .optionallyWith(
        openProactiveInsights.map(value =>
          NumOpenProactiveInsights.unwrap(value): Integer
        )
      )(_.openProactiveInsights)
      .optionallyWith(
        openReactiveInsights.map(value =>
          NumOpenReactiveInsights.unwrap(value): Integer
        )
      )(_.openReactiveInsights)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly =
    zio.aws.devopsguru.model.ServiceInsightHealth.wrap(buildAwsValue())
}
object ServiceInsightHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ServiceInsightHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ServiceInsightHealth =
      zio.aws.devopsguru.model.ServiceInsightHealth(
        openProactiveInsights.map(value => value),
        openReactiveInsights.map(value => value)
      )
    def openProactiveInsights: Optional[NumOpenProactiveInsights]
    def openReactiveInsights: Optional[NumOpenReactiveInsights]
    def getOpenProactiveInsights: ZIO[Any, AwsError, NumOpenProactiveInsights] =
      AwsError.unwrapOptionField("openProactiveInsights", openProactiveInsights)
    def getOpenReactiveInsights: ZIO[Any, AwsError, NumOpenReactiveInsights] =
      AwsError.unwrapOptionField("openReactiveInsights", openReactiveInsights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceInsightHealth
  ) extends zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly {
    override val openProactiveInsights: Optional[NumOpenProactiveInsights] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openProactiveInsights())
        .map(value =>
          zio.aws.devopsguru.model.primitives.NumOpenProactiveInsights(value)
        )
    override val openReactiveInsights: Optional[NumOpenReactiveInsights] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openReactiveInsights())
        .map(value =>
          zio.aws.devopsguru.model.primitives.NumOpenReactiveInsights(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceInsightHealth
  ): zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly = new Wrapper(impl)
}
