package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutFeedbackRequest(
    insightFeedback: Option[zio.aws.devopsguru.model.InsightFeedback] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest = {
    import PutFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest
      .builder()
      .optionallyWith(insightFeedback.map(value => value.buildAwsValue()))(
        _.insightFeedback
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.PutFeedbackRequest.ReadOnly =
    zio.aws.devopsguru.model.PutFeedbackRequest.wrap(buildAwsValue())
}
object PutFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.PutFeedbackRequest =
      zio.aws.devopsguru.model
        .PutFeedbackRequest(insightFeedback.map(value => value.asEditable))
    def insightFeedback
        : Option[zio.aws.devopsguru.model.InsightFeedback.ReadOnly]
    def getInsightFeedback: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightFeedback.ReadOnly
    ] = AwsError.unwrapOptionField("insightFeedback", insightFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest
  ) extends zio.aws.devopsguru.model.PutFeedbackRequest.ReadOnly {
    override val insightFeedback
        : Option[zio.aws.devopsguru.model.InsightFeedback.ReadOnly] = scala
      .Option(impl.insightFeedback())
      .map(value => zio.aws.devopsguru.model.InsightFeedback.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest
  ): zio.aws.devopsguru.model.PutFeedbackRequest.ReadOnly = new Wrapper(impl)
}
