package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{MetricValue, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TimestampMetricValuePair(
    timestamp: Option[Timestamp] = None,
    metricValue: Option[MetricValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair = {
    import TimestampMetricValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        metricValue.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.metricValue)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly =
    zio.aws.devopsguru.model.TimestampMetricValuePair.wrap(buildAwsValue())
}
object TimestampMetricValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.TimestampMetricValuePair =
      zio.aws.devopsguru.model.TimestampMetricValuePair(
        timestamp.map(value => value),
        metricValue.map(value => value)
      )
    def timestamp: Option[Timestamp]
    def metricValue: Option[MetricValue]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getMetricValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("metricValue", metricValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
  ) extends zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val metricValue: Option[MetricValue] = scala
      .Option(impl.metricValue())
      .map(value => zio.aws.devopsguru.model.primitives.MetricValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
  ): zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly = new Wrapper(
    impl
  )
}
