package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.PerformanceInsightsValueDouble
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PerformanceInsightsReferenceScalar(
    value: Option[PerformanceInsightsValueDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceScalar = {
    import PerformanceInsightsReferenceScalar.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceScalar
      .builder()
      .optionallyWith(
        value.map(value =>
          PerformanceInsightsValueDouble.unwrap(value): java.lang.Double
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar
      .wrap(buildAwsValue())
}
object PerformanceInsightsReferenceScalar {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceScalar
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar =
      zio.aws.devopsguru.model
        .PerformanceInsightsReferenceScalar(value.map(value => value))
    def value: Option[PerformanceInsightsValueDouble]
    def getValue: ZIO[Any, AwsError, PerformanceInsightsValueDouble] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceScalar
  ) extends zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar.ReadOnly {
    override val value: Option[PerformanceInsightsValueDouble] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .PerformanceInsightsValueDouble(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceScalar
  ): zio.aws.devopsguru.model.PerformanceInsightsReferenceScalar.ReadOnly =
    new Wrapper(impl)
}
