package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  EventResourceArn,
  EventResourceName,
  EventResourceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EventResource(
    `type`: Option[EventResourceType] = None,
    name: Option[EventResourceName] = None,
    arn: Option[EventResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.EventResource = {
    import EventResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.EventResource
      .builder()
      .optionallyWith(
        `type`.map(value => EventResourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        name.map(value => EventResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => EventResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.EventResource.ReadOnly =
    zio.aws.devopsguru.model.EventResource.wrap(buildAwsValue())
}
object EventResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.EventResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.EventResource =
      zio.aws.devopsguru.model.EventResource(
        `type`.map(value => value),
        name.map(value => value),
        arn.map(value => value)
      )
    def `type`: Option[EventResourceType]
    def name: Option[EventResourceName]
    def arn: Option[EventResourceArn]
    def getType: ZIO[Any, AwsError, EventResourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, EventResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, EventResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.EventResource
  ) extends zio.aws.devopsguru.model.EventResource.ReadOnly {
    override val `type`: Option[EventResourceType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.devopsguru.model.primitives.EventResourceType(value)
      )
    override val name: Option[EventResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.devopsguru.model.primitives.EventResourceName(value)
      )
    override val arn: Option[EventResourceArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.devopsguru.model.primitives.EventResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.EventResource
  ): zio.aws.devopsguru.model.EventResource.ReadOnly = new Wrapper(impl)
}
