package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  UuidNextToken,
  ListInsightsMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInsightsRequest(
    statusFilter: zio.aws.devopsguru.model.ListInsightsStatusFilter,
    maxResults: Option[ListInsightsMaxResults] = None,
    nextToken: Option[UuidNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest = {
    import ListInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest
      .builder()
      .statusFilter(statusFilter.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => ListInsightsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ListInsightsRequest.ReadOnly =
    zio.aws.devopsguru.model.ListInsightsRequest.wrap(buildAwsValue())
}
object ListInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListInsightsRequest =
      zio.aws.devopsguru.model.ListInsightsRequest(
        statusFilter.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def statusFilter: zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly
    def maxResults: Option[ListInsightsMaxResults]
    def nextToken: Option[UuidNextToken]
    def getStatusFilter: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly
    ] = ZIO.succeed(statusFilter)
    def getMaxResults: ZIO[Any, AwsError, ListInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest
  ) extends zio.aws.devopsguru.model.ListInsightsRequest.ReadOnly {
    override val statusFilter
        : zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly =
      zio.aws.devopsguru.model.ListInsightsStatusFilter
        .wrap(impl.statusFilter())
    override val maxResults: Option[ListInsightsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.devopsguru.model.primitives.ListInsightsMaxResults(value)
      )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest
  ): zio.aws.devopsguru.model.ListInsightsRequest.ReadOnly = new Wrapper(impl)
}
