package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceHealth(
    serviceName: Option[zio.aws.devopsguru.model.ServiceName] = None,
    insight: Option[zio.aws.devopsguru.model.ServiceInsightHealth] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ServiceHealth = {
    import ServiceHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ServiceHealth
      .builder()
      .optionallyWith(serviceName.map(value => value.unwrap))(_.serviceName)
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ServiceHealth.ReadOnly =
    zio.aws.devopsguru.model.ServiceHealth.wrap(buildAwsValue())
}
object ServiceHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ServiceHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ServiceHealth =
      zio.aws.devopsguru.model.ServiceHealth(
        serviceName.map(value => value),
        insight.map(value => value.asEditable)
      )
    def serviceName: Option[zio.aws.devopsguru.model.ServiceName]
    def insight: Option[zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly]
    def getServiceName
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getInsight: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly
    ] = AwsError.unwrapOptionField("insight", insight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceHealth
  ) extends zio.aws.devopsguru.model.ServiceHealth.ReadOnly {
    override val serviceName: Option[zio.aws.devopsguru.model.ServiceName] =
      scala
        .Option(impl.serviceName())
        .map(value => zio.aws.devopsguru.model.ServiceName.wrap(value))
    override val insight
        : Option[zio.aws.devopsguru.model.ServiceInsightHealth.ReadOnly] = scala
      .Option(impl.insight())
      .map(value => zio.aws.devopsguru.model.ServiceInsightHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceHealth
  ): zio.aws.devopsguru.model.ServiceHealth.ReadOnly = new Wrapper(impl)
}
