package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  CloudWatchMetricsDimensionValue,
  CloudWatchMetricsDimensionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloudWatchMetricsDimension(
    name: Option[CloudWatchMetricsDimensionName] = None,
    value: Option[CloudWatchMetricsDimensionValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension = {
    import CloudWatchMetricsDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
      .builder()
      .optionallyWith(
        name.map(value =>
          CloudWatchMetricsDimensionName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        value.map(value =>
          CloudWatchMetricsDimensionValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly =
    zio.aws.devopsguru.model.CloudWatchMetricsDimension.wrap(buildAwsValue())
}
object CloudWatchMetricsDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudWatchMetricsDimension =
      zio.aws.devopsguru.model.CloudWatchMetricsDimension(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Option[CloudWatchMetricsDimensionName]
    def value: Option[CloudWatchMetricsDimensionValue]
    def getName: ZIO[Any, AwsError, CloudWatchMetricsDimensionName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, CloudWatchMetricsDimensionValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
  ) extends zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly {
    override val name: Option[CloudWatchMetricsDimensionName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .CloudWatchMetricsDimensionName(value)
      )
    override val value: Option[CloudWatchMetricsDimensionValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .CloudWatchMetricsDimensionValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension
  ): zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly = new Wrapper(
    impl
  )
}
