package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  CloudWatchMetricsPeriod,
  CloudWatchMetricsUnit,
  CloudWatchMetricsNamespace,
  CloudWatchMetricsMetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloudWatchMetricsDetail(
    metricName: Option[CloudWatchMetricsMetricName] = None,
    namespace: Option[CloudWatchMetricsNamespace] = None,
    dimensions: Option[
      Iterable[zio.aws.devopsguru.model.CloudWatchMetricsDimension]
    ] = None,
    stat: Option[zio.aws.devopsguru.model.CloudWatchMetricsStat] = None,
    unit: Option[CloudWatchMetricsUnit] = None,
    period: Option[CloudWatchMetricsPeriod] = None,
    metricDataSummary: Option[
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail = {
    import CloudWatchMetricsDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
      .builder()
      .optionallyWith(
        metricName.map(value =>
          CloudWatchMetricsMetricName.unwrap(value): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(
        namespace.map(value =>
          CloudWatchMetricsNamespace.unwrap(value): java.lang.String
        )
      )(_.namespace)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(stat.map(value => value.unwrap))(_.stat)
      .optionallyWith(
        unit.map(value => CloudWatchMetricsUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(
        period.map(value => CloudWatchMetricsPeriod.unwrap(value): Integer)
      )(_.period)
      .optionallyWith(metricDataSummary.map(value => value.buildAwsValue()))(
        _.metricDataSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly =
    zio.aws.devopsguru.model.CloudWatchMetricsDetail.wrap(buildAwsValue())
}
object CloudWatchMetricsDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudWatchMetricsDetail =
      zio.aws.devopsguru.model.CloudWatchMetricsDetail(
        metricName.map(value => value),
        namespace.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stat.map(value => value),
        unit.map(value => value),
        period.map(value => value),
        metricDataSummary.map(value => value.asEditable)
      )
    def metricName: Option[CloudWatchMetricsMetricName]
    def namespace: Option[CloudWatchMetricsNamespace]
    def dimensions: Option[
      List[zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly]
    ]
    def stat: Option[zio.aws.devopsguru.model.CloudWatchMetricsStat]
    def unit: Option[CloudWatchMetricsUnit]
    def period: Option[CloudWatchMetricsPeriod]
    def metricDataSummary
        : Option[zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly]
    def getMetricName: ZIO[Any, AwsError, CloudWatchMetricsMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, CloudWatchMetricsNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStat
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.CloudWatchMetricsStat] =
      AwsError.unwrapOptionField("stat", stat)
    def getUnit: ZIO[Any, AwsError, CloudWatchMetricsUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getPeriod: ZIO[Any, AwsError, CloudWatchMetricsPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getMetricDataSummary: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly
    ] = AwsError.unwrapOptionField("metricDataSummary", metricDataSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
  ) extends zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly {
    override val metricName: Option[CloudWatchMetricsMetricName] = scala
      .Option(impl.metricName())
      .map(value =>
        zio.aws.devopsguru.model.primitives.CloudWatchMetricsMetricName(value)
      )
    override val namespace: Option[CloudWatchMetricsNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.devopsguru.model.primitives.CloudWatchMetricsNamespace(value)
      )
    override val dimensions: Option[
      List[zio.aws.devopsguru.model.CloudWatchMetricsDimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.CloudWatchMetricsDimension.wrap(item)
        }.toList
      )
    override val stat: Option[zio.aws.devopsguru.model.CloudWatchMetricsStat] =
      scala
        .Option(impl.stat())
        .map(value =>
          zio.aws.devopsguru.model.CloudWatchMetricsStat.wrap(value)
        )
    override val unit: Option[CloudWatchMetricsUnit] = scala
      .Option(impl.unit())
      .map(value =>
        zio.aws.devopsguru.model.primitives.CloudWatchMetricsUnit(value)
      )
    override val period: Option[CloudWatchMetricsPeriod] = scala
      .Option(impl.period())
      .map(value =>
        zio.aws.devopsguru.model.primitives.CloudWatchMetricsPeriod(value)
      )
    override val metricDataSummary: Option[
      zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.ReadOnly
    ] = scala
      .Option(impl.metricDataSummary())
      .map(value =>
        zio.aws.devopsguru.model.CloudWatchMetricsDataSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail
  ): zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly = new Wrapper(
    impl
  )
}
