package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  AnomalyLimit,
  InsightId,
  Timestamp,
  AnomalyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ProactiveAnomalySummary(
    id: Option[AnomalyId] = None,
    severity: Option[zio.aws.devopsguru.model.AnomalySeverity] = None,
    status: Option[zio.aws.devopsguru.model.AnomalyStatus] = None,
    updateTime: Option[Timestamp] = None,
    anomalyTimeRange: Option[zio.aws.devopsguru.model.AnomalyTimeRange] = None,
    anomalyReportedTimeRange: Option[
      zio.aws.devopsguru.model.AnomalyReportedTimeRange
    ] = None,
    predictionTimeRange: Option[zio.aws.devopsguru.model.PredictionTimeRange] =
      None,
    sourceDetails: Option[zio.aws.devopsguru.model.AnomalySourceDetails] = None,
    associatedInsightId: Option[InsightId] = None,
    resourceCollection: Option[zio.aws.devopsguru.model.ResourceCollection] =
      None,
    limit: Option[AnomalyLimit] = None,
    sourceMetadata: Option[zio.aws.devopsguru.model.AnomalySourceMetadata] =
      None,
    anomalyResources: Option[
      Iterable[zio.aws.devopsguru.model.AnomalyResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary = {
    import ProactiveAnomalySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary
      .builder()
      .optionallyWith(
        id.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        updateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateTime)
      .optionallyWith(anomalyTimeRange.map(value => value.buildAwsValue()))(
        _.anomalyTimeRange
      )
      .optionallyWith(
        anomalyReportedTimeRange.map(value => value.buildAwsValue())
      )(_.anomalyReportedTimeRange)
      .optionallyWith(predictionTimeRange.map(value => value.buildAwsValue()))(
        _.predictionTimeRange
      )
      .optionallyWith(sourceDetails.map(value => value.buildAwsValue()))(
        _.sourceDetails
      )
      .optionallyWith(
        associatedInsightId.map(value =>
          InsightId.unwrap(value): java.lang.String
        )
      )(_.associatedInsightId)
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(
        limit.map(value => AnomalyLimit.unwrap(value): java.lang.Double)
      )(_.limit)
      .optionallyWith(sourceMetadata.map(value => value.buildAwsValue()))(
        _.sourceMetadata
      )
      .optionallyWith(
        anomalyResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.anomalyResources)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ProactiveAnomalySummary.ReadOnly =
    zio.aws.devopsguru.model.ProactiveAnomalySummary.wrap(buildAwsValue())
}
object ProactiveAnomalySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ProactiveAnomalySummary =
      zio.aws.devopsguru.model.ProactiveAnomalySummary(
        id.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        updateTime.map(value => value),
        anomalyTimeRange.map(value => value.asEditable),
        anomalyReportedTimeRange.map(value => value.asEditable),
        predictionTimeRange.map(value => value.asEditable),
        sourceDetails.map(value => value.asEditable),
        associatedInsightId.map(value => value),
        resourceCollection.map(value => value.asEditable),
        limit.map(value => value),
        sourceMetadata.map(value => value.asEditable),
        anomalyResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Option[AnomalyId]
    def severity: Option[zio.aws.devopsguru.model.AnomalySeverity]
    def status: Option[zio.aws.devopsguru.model.AnomalyStatus]
    def updateTime: Option[Timestamp]
    def anomalyTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly]
    def anomalyReportedTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly]
    def predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly]
    def sourceDetails
        : Option[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly]
    def associatedInsightId: Option[InsightId]
    def resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def limit: Option[AnomalyLimit]
    def sourceMetadata
        : Option[zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly]
    def anomalyResources
        : Option[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]]
    def getId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("id", id)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalySeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateTime", updateTime)
    def getAnomalyTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("anomalyTimeRange", anomalyTimeRange)
    def getAnomalyReportedTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "anomalyReportedTimeRange",
      anomalyReportedTimeRange
    )
    def getPredictionTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("predictionTimeRange", predictionTimeRange)
    def getSourceDetails: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDetails", sourceDetails)
    def getAssociatedInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("associatedInsightId", associatedInsightId)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getLimit: ZIO[Any, AwsError, AnomalyLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getSourceMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("sourceMetadata", sourceMetadata)
    def getAnomalyResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.AnomalyResource.ReadOnly
    ]] = AwsError.unwrapOptionField("anomalyResources", anomalyResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary
  ) extends zio.aws.devopsguru.model.ProactiveAnomalySummary.ReadOnly {
    override val id: Option[AnomalyId] = scala
      .Option(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
    override val severity: Option[zio.aws.devopsguru.model.AnomalySeverity] =
      scala
        .Option(impl.severity())
        .map(value => zio.aws.devopsguru.model.AnomalySeverity.wrap(value))
    override val status: Option[zio.aws.devopsguru.model.AnomalyStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devopsguru.model.AnomalyStatus.wrap(value))
    override val updateTime: Option[Timestamp] = scala
      .Option(impl.updateTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val anomalyTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly] = scala
      .Option(impl.anomalyTimeRange())
      .map(value => zio.aws.devopsguru.model.AnomalyTimeRange.wrap(value))
    override val anomalyReportedTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly] =
      scala
        .Option(impl.anomalyReportedTimeRange())
        .map(value =>
          zio.aws.devopsguru.model.AnomalyReportedTimeRange.wrap(value)
        )
    override val predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly] = scala
      .Option(impl.predictionTimeRange())
      .map(value => zio.aws.devopsguru.model.PredictionTimeRange.wrap(value))
    override val sourceDetails
        : Option[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly] = scala
      .Option(impl.sourceDetails())
      .map(value => zio.aws.devopsguru.model.AnomalySourceDetails.wrap(value))
    override val associatedInsightId: Option[InsightId] = scala
      .Option(impl.associatedInsightId())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] = scala
      .Option(impl.resourceCollection())
      .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val limit: Option[AnomalyLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyLimit(value))
    override val sourceMetadata
        : Option[zio.aws.devopsguru.model.AnomalySourceMetadata.ReadOnly] =
      scala
        .Option(impl.sourceMetadata())
        .map(value =>
          zio.aws.devopsguru.model.AnomalySourceMetadata.wrap(value)
        )
    override val anomalyResources
        : Option[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]] =
      scala
        .Option(impl.anomalyResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.AnomalyResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary
  ): zio.aws.devopsguru.model.ProactiveAnomalySummary.ReadOnly = new Wrapper(
    impl
  )
}
