package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  PerformanceInsightsMetricFilterValue,
  PerformanceInsightsMetricFilterKey,
  PerformanceInsightsMetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PerformanceInsightsMetricQuery(
    metric: Option[PerformanceInsightsMetricName] = None,
    groupBy: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup
    ] = None,
    filter: Option[Map[
      PerformanceInsightsMetricFilterKey,
      PerformanceInsightsMetricFilterValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricQuery = {
    import PerformanceInsightsMetricQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricQuery
      .builder()
      .optionallyWith(
        metric.map(value =>
          PerformanceInsightsMetricName.unwrap(value): java.lang.String
        )
      )(_.metric)
      .optionallyWith(groupBy.map(value => value.buildAwsValue()))(_.groupBy)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (PerformanceInsightsMetricFilterKey.unwrap(
                key
              ): java.lang.String) -> (PerformanceInsightsMetricFilterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsMetricQuery
      .wrap(buildAwsValue())
}
object PerformanceInsightsMetricQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.PerformanceInsightsMetricQuery =
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery(
        metric.map(value => value),
        groupBy.map(value => value.asEditable),
        filter.map(value => value)
      )
    def metric: Option[PerformanceInsightsMetricName]
    def groupBy: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly
    ]
    def filter: Option[Map[
      PerformanceInsightsMetricFilterKey,
      PerformanceInsightsMetricFilterValue
    ]]
    def getMetric: ZIO[Any, AwsError, PerformanceInsightsMetricName] =
      AwsError.unwrapOptionField("metric", metric)
    def getGroupBy: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly
    ] = AwsError.unwrapOptionField("groupBy", groupBy)
    def getFilter: ZIO[Any, AwsError, Map[
      PerformanceInsightsMetricFilterKey,
      PerformanceInsightsMetricFilterValue
    ]] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricQuery
  ) extends zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly {
    override val metric: Option[PerformanceInsightsMetricName] = scala
      .Option(impl.metric())
      .map(value =>
        zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricName(value)
      )
    override val groupBy: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly
    ] = scala
      .Option(impl.groupBy())
      .map(value =>
        zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup
          .wrap(value)
      )
    override val filter: Option[Map[
      PerformanceInsightsMetricFilterKey,
      PerformanceInsightsMetricFilterValue
    ]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.devopsguru.model.primitives
              .PerformanceInsightsMetricFilterKey(
                key
              ) -> zio.aws.devopsguru.model.primitives
              .PerformanceInsightsMetricFilterValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricQuery
  ): zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly =
    new Wrapper(impl)
}
