package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListNotificationChannelsRequest(
    nextToken: Option[UuidNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest = {
    import ListNotificationChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListNotificationChannelsRequest.ReadOnly =
    zio.aws.devopsguru.model.ListNotificationChannelsRequest
      .wrap(buildAwsValue())
}
object ListNotificationChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListNotificationChannelsRequest =
      zio.aws.devopsguru.model
        .ListNotificationChannelsRequest(nextToken.map(value => value))
    def nextToken: Option[UuidNextToken]
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest
  ) extends zio.aws.devopsguru.model.ListNotificationChannelsRequest.ReadOnly {
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest
  ): zio.aws.devopsguru.model.ListNotificationChannelsRequest.ReadOnly =
    new Wrapper(impl)
}
