package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  MeanTimeToRecoverInMilliseconds,
  NumProactiveInsights,
  NumReactiveInsights
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAccountOverviewResponse(
    reactiveInsights: NumReactiveInsights,
    proactiveInsights: NumProactiveInsights,
    meanTimeToRecoverInMilliseconds: MeanTimeToRecoverInMilliseconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse = {
    import DescribeAccountOverviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse
      .builder()
      .reactiveInsights(NumReactiveInsights.unwrap(reactiveInsights): Integer)
      .proactiveInsights(
        NumProactiveInsights.unwrap(proactiveInsights): Integer
      )
      .meanTimeToRecoverInMilliseconds(
        MeanTimeToRecoverInMilliseconds.unwrap(
          meanTimeToRecoverInMilliseconds
        ): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeAccountOverviewResponse
      .wrap(buildAwsValue())
}
object DescribeAccountOverviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeAccountOverviewResponse =
      zio.aws.devopsguru.model.DescribeAccountOverviewResponse(
        reactiveInsights,
        proactiveInsights,
        meanTimeToRecoverInMilliseconds
      )
    def reactiveInsights: NumReactiveInsights
    def proactiveInsights: NumProactiveInsights
    def meanTimeToRecoverInMilliseconds: MeanTimeToRecoverInMilliseconds
    def getReactiveInsights: ZIO[Any, Nothing, NumReactiveInsights] =
      ZIO.succeed(reactiveInsights)
    def getProactiveInsights: ZIO[Any, Nothing, NumProactiveInsights] =
      ZIO.succeed(proactiveInsights)
    def getMeanTimeToRecoverInMilliseconds
        : ZIO[Any, Nothing, MeanTimeToRecoverInMilliseconds] =
      ZIO.succeed(meanTimeToRecoverInMilliseconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse
  ) extends zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly {
    override val reactiveInsights: NumReactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumReactiveInsights(impl.reactiveInsights())
    override val proactiveInsights: NumProactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumProactiveInsights(impl.proactiveInsights())
    override val meanTimeToRecoverInMilliseconds
        : MeanTimeToRecoverInMilliseconds = zio.aws.devopsguru.model.primitives
      .MeanTimeToRecoverInMilliseconds(impl.meanTimeToRecoverInMilliseconds())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse
  ): zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly =
    new Wrapper(impl)
}
