package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{AwsAccountId, AnomalyId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAnomalyRequest(
    id: AnomalyId,
    accountId: Option[AwsAccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest = {
    import DescribeAnomalyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest
      .builder()
      .id(AnomalyId.unwrap(id): java.lang.String)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.DescribeAnomalyRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeAnomalyRequest.wrap(buildAwsValue())
}
object DescribeAnomalyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeAnomalyRequest =
      zio.aws.devopsguru.model
        .DescribeAnomalyRequest(id, accountId.map(value => value))
    def id: AnomalyId
    def accountId: Option[AwsAccountId]
    def getId: ZIO[Any, Nothing, AnomalyId] = ZIO.succeed(id)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest
  ) extends zio.aws.devopsguru.model.DescribeAnomalyRequest.ReadOnly {
    override val id: AnomalyId =
      zio.aws.devopsguru.model.primitives.AnomalyId(impl.id())
    override val accountId: Option[AwsAccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest
  ): zio.aws.devopsguru.model.DescribeAnomalyRequest.ReadOnly = new Wrapper(
    impl
  )
}
