package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PerformanceInsightsReferenceMetric(
    metricQuery: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceMetric = {
    import PerformanceInsightsReferenceMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceMetric
      .builder()
      .optionallyWith(metricQuery.map(value => value.buildAwsValue()))(
        _.metricQuery
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric
      .wrap(buildAwsValue())
}
object PerformanceInsightsReferenceMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric =
      zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric(
        metricQuery.map(value => value.asEditable)
      )
    def metricQuery: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ]
    def getMetricQuery: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ] = AwsError.unwrapOptionField("metricQuery", metricQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceMetric
  ) extends zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric.ReadOnly {
    override val metricQuery: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ] = scala
      .Option(impl.metricQuery())
      .map(value =>
        zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceMetric
  ): zio.aws.devopsguru.model.PerformanceInsightsReferenceMetric.ReadOnly =
    new Wrapper(impl)
}
