package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  InsightName,
  OrganizationalUnitId,
  AwsAccountId,
  InsightId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProactiveOrganizationInsightSummary(
    id: Option[InsightId] = None,
    accountId: Option[AwsAccountId] = None,
    organizationalUnitId: Option[OrganizationalUnitId] = None,
    name: Option[InsightName] = None,
    severity: Option[zio.aws.devopsguru.model.InsightSeverity] = None,
    status: Option[zio.aws.devopsguru.model.InsightStatus] = None,
    insightTimeRange: Option[zio.aws.devopsguru.model.InsightTimeRange] = None,
    predictionTimeRange: Option[zio.aws.devopsguru.model.PredictionTimeRange] =
      None,
    resourceCollection: Option[zio.aws.devopsguru.model.ResourceCollection] =
      None,
    serviceCollection: Option[zio.aws.devopsguru.model.ServiceCollection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary = {
    import ProactiveOrganizationInsightSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
      .builder()
      .optionallyWith(
        id.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        organizationalUnitId.map(value =>
          OrganizationalUnitId.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitId)
      .optionallyWith(
        name.map(value => InsightName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(insightTimeRange.map(value => value.buildAwsValue()))(
        _.insightTimeRange
      )
      .optionallyWith(predictionTimeRange.map(value => value.buildAwsValue()))(
        _.predictionTimeRange
      )
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(serviceCollection.map(value => value.buildAwsValue()))(
        _.serviceCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly =
    zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary
      .wrap(buildAwsValue())
}
object ProactiveOrganizationInsightSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary =
      zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary(
        id.map(value => value),
        accountId.map(value => value),
        organizationalUnitId.map(value => value),
        name.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        insightTimeRange.map(value => value.asEditable),
        predictionTimeRange.map(value => value.asEditable),
        resourceCollection.map(value => value.asEditable),
        serviceCollection.map(value => value.asEditable)
      )
    def id: Option[InsightId]
    def accountId: Option[AwsAccountId]
    def organizationalUnitId: Option[OrganizationalUnitId]
    def name: Option[InsightName]
    def severity: Option[zio.aws.devopsguru.model.InsightSeverity]
    def status: Option[zio.aws.devopsguru.model.InsightStatus]
    def insightTimeRange
        : Option[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly]
    def predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly]
    def resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def serviceCollection
        : Option[zio.aws.devopsguru.model.ServiceCollection.ReadOnly]
    def getId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("id", id)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getOrganizationalUnitId: ZIO[Any, AwsError, OrganizationalUnitId] =
      AwsError.unwrapOptionField("organizationalUnitId", organizationalUnitId)
    def getName: ZIO[Any, AwsError, InsightName] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInsightTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("insightTimeRange", insightTimeRange)
    def getPredictionTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("predictionTimeRange", predictionTimeRange)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getServiceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("serviceCollection", serviceCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
  ) extends zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly {
    override val id: Option[InsightId] = scala
      .Option(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val accountId: Option[AwsAccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
    override val organizationalUnitId: Option[OrganizationalUnitId] = scala
      .Option(impl.organizationalUnitId())
      .map(value =>
        zio.aws.devopsguru.model.primitives.OrganizationalUnitId(value)
      )
    override val name: Option[InsightName] = scala
      .Option(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.InsightName(value))
    override val severity: Option[zio.aws.devopsguru.model.InsightSeverity] =
      scala
        .Option(impl.severity())
        .map(value => zio.aws.devopsguru.model.InsightSeverity.wrap(value))
    override val status: Option[zio.aws.devopsguru.model.InsightStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devopsguru.model.InsightStatus.wrap(value))
    override val insightTimeRange
        : Option[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly] = scala
      .Option(impl.insightTimeRange())
      .map(value => zio.aws.devopsguru.model.InsightTimeRange.wrap(value))
    override val predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly] = scala
      .Option(impl.predictionTimeRange())
      .map(value => zio.aws.devopsguru.model.PredictionTimeRange.wrap(value))
    override val resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] = scala
      .Option(impl.resourceCollection())
      .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val serviceCollection
        : Option[zio.aws.devopsguru.model.ServiceCollection.ReadOnly] = scala
      .Option(impl.serviceCollection())
      .map(value => zio.aws.devopsguru.model.ServiceCollection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveOrganizationInsightSummary
  ): zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly =
    new Wrapper(impl)
}
