package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  ResourceHours,
  NumMetricsAnalyzed,
  NumOpenProactiveInsights,
  NumOpenReactiveInsights
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAccountHealthResponse(
    openReactiveInsights: NumOpenReactiveInsights,
    openProactiveInsights: NumOpenProactiveInsights,
    metricsAnalyzed: NumMetricsAnalyzed,
    resourceHours: ResourceHours
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse = {
    import DescribeAccountHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
      .builder()
      .openReactiveInsights(
        NumOpenReactiveInsights.unwrap(openReactiveInsights): Integer
      )
      .openProactiveInsights(
        NumOpenProactiveInsights.unwrap(openProactiveInsights): Integer
      )
      .metricsAnalyzed(NumMetricsAnalyzed.unwrap(metricsAnalyzed): Integer)
      .resourceHours(ResourceHours.unwrap(resourceHours): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeAccountHealthResponse.wrap(buildAwsValue())
}
object DescribeAccountHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeAccountHealthResponse =
      zio.aws.devopsguru.model.DescribeAccountHealthResponse(
        openReactiveInsights,
        openProactiveInsights,
        metricsAnalyzed,
        resourceHours
      )
    def openReactiveInsights: NumOpenReactiveInsights
    def openProactiveInsights: NumOpenProactiveInsights
    def metricsAnalyzed: NumMetricsAnalyzed
    def resourceHours: ResourceHours
    def getOpenReactiveInsights: ZIO[Any, Nothing, NumOpenReactiveInsights] =
      ZIO.succeed(openReactiveInsights)
    def getOpenProactiveInsights: ZIO[Any, Nothing, NumOpenProactiveInsights] =
      ZIO.succeed(openProactiveInsights)
    def getMetricsAnalyzed: ZIO[Any, Nothing, NumMetricsAnalyzed] =
      ZIO.succeed(metricsAnalyzed)
    def getResourceHours: ZIO[Any, Nothing, ResourceHours] =
      ZIO.succeed(resourceHours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
  ) extends zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly {
    override val openReactiveInsights: NumOpenReactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumOpenReactiveInsights(impl.openReactiveInsights())
    override val openProactiveInsights: NumOpenProactiveInsights =
      zio.aws.devopsguru.model.primitives
        .NumOpenProactiveInsights(impl.openProactiveInsights())
    override val metricsAnalyzed: NumMetricsAnalyzed =
      zio.aws.devopsguru.model.primitives
        .NumMetricsAnalyzed(impl.metricsAnalyzed())
    override val resourceHours: ResourceHours =
      zio.aws.devopsguru.model.primitives.ResourceHours(impl.resourceHours())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse
  ): zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly =
    new Wrapper(impl)
}
